/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DSAPublicKey
extends PublicKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;

    public DSAPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected DSAPublicKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DSAPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)super.clone();
        dSAPublicKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dSAPublicKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        dSAPublicKey.base_ = (ByteArrayAttribute)this.base_.clone();
        dSAPublicKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DSAPublicKey.putAttributesInTable(dSAPublicKey);
        return dSAPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
            bl = this == dSAPublicKey || super.equals(dSAPublicKey) && this.prime_.equals(dSAPublicKey.prime_) && this.subprime_.equals(dSAPublicKey.subprime_) && this.base_.equals(dSAPublicKey.base_) && this.value_.equals(dSAPublicKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new DSAPublicKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DSAPublicKey dSAPublicKey) {
        if (dSAPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dSAPublicKey.attributeTable_.put(Attribute.PRIME, dSAPublicKey.prime_);
        dSAPublicKey.attributeTable_.put(Attribute.SUBPRIME, dSAPublicKey.subprime_);
        dSAPublicKey.attributeTable_.put(Attribute.BASE, dSAPublicKey.base_);
        dSAPublicKey.attributeTable_.put(Attribute.VALUE, dSAPublicKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.subprime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

